/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.minecraft.ui.containers.views;

import com.google.common.base.Suppliers;
import java.util.Optional;
import net.impactdev.impactor.api.platform.players.PlatformPlayer;
import net.impactdev.impactor.api.ui.containers.View;
import net.impactdev.impactor.api.ui.containers.processors.ClickProcessor;
import net.impactdev.impactor.api.ui.containers.processors.CloseProcessor;
import net.impactdev.impactor.api.ui.metadata.UIMetadataKeys;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;

public abstract class ImpactorView
implements View {
    protected final Key namespace;
    protected final Component title;
    protected final boolean readonly;
    protected final ClickProcessor click;
    protected final CloseProcessor close;

    protected ImpactorView(Key namespace, Component title, boolean readonly, ClickProcessor click, CloseProcessor close) {
        this.namespace = Optional.ofNullable(namespace).orElseThrow(() -> new IllegalStateException("Provider was not specified"));
        this.title = title;
        this.readonly = readonly;
        this.click = click;
        this.close = close;
    }

    @Override
    public Key namespace() {
        return this.namespace;
    }

    @Override
    public Component title() {
        return this.title;
    }

    @Override
    public boolean readonly() {
        return this.readonly;
    }

    public ClickProcessor clickProcessor() {
        return this.click;
    }

    public CloseProcessor closeProcessor() {
        return this.close;
    }

    @Override
    public void open(PlatformPlayer viewer) {
        viewer.offer(UIMetadataKeys.OPENED_VIEW, Suppliers.memoize(() -> this));
    }

    @Override
    public void close(PlatformPlayer viewer) {
        viewer.offer(UIMetadataKeys.OPENED_VIEW, null);
    }
}

